#include <algorithm>
#include <cstdint>
#include <cstring>
#include <iostream>
#include <stack>
#include <tuple>
#include <unordered_map>
#include <vector>

typedef std::unordered_map<uint16_t, std::unordered_map<uint16_t, int16_t>> Graph;
constexpr int16_t INF = 30000;
constexpr int16_t NEG_INF = -30000;
constexpr int16_t unvisited = -1;

constexpr uint32_t MAX_N = 1000000;
constexpr int32_t NOT_FOUND = INT32_MAX;
constexpr bool LEFT = false;
constexpr bool RIGHT = true;

/*
Mislim da ceo ovaj program uzasno izgleda jer sam pola
uradio u iskljucivo C stil a pola u iskljucivo C++ stil
lepse bi izgledao u samo C++ jer ne bi morao da implementiram stack

Isto ako Vam nije ulimit -s unlimited ovo
ima da da RTE. Ipak sam napravi integer overflow.
*/

typedef struct jarbol {
	int32_t x;
	int32_t y;
} Jarbol;

// koristimo obicnu tehniku monotonog steka
[[gnu::hot]]
static void next_gte(const Jarbol (&array)[MAX_N], int32_t (&next)[MAX_N], const uint32_t n, bool direction) {
	std::stack<uint32_t> stack;
	int32_t start, end, i;
	int32_t inc;
	
	start = (direction) ? 0 : n-1;
	end = (direction) ? n : -1;
	inc = (direction) ? 1 : -1;

	for ( i = start; i != end; i += inc) {
		while(!stack.empty() && array[stack.top()].y >= array[i].y) {
			next[stack.top()] = i;
			stack.pop();
		}
		stack.push(i);
	}
}

[[gnu::noreturn]]
static void solve(const Jarbol (&points)[MAX_N], const uint32_t n) {
	if(n == 1) {
		std::cout << -1 << '\n';
		std::exit(0);
	}

	int32_t next_left[MAX_N];
	int32_t next_right[MAX_N];
	int64_t left_dist, right_dist;
	uint32_t i;

	// inicijalizujemo oba niza u slucaju
	// da nema vecih sa leve ili desne
	for(i = 0; i < n; ++i)
		 next_left[i] = next_right[i] = NOT_FOUND;

	next_gte(points, next_left, n, LEFT);
	next_gte(points, next_right, n, RIGHT);

	// sad izracunamo i primenimo specificne probleme za ovaj
	// zadatak, to da mozemo da izvedemo bez ikakvih problema
	// da je razdaljina (x2 - x1) - (y2 - y1), ali ne kada je y1 == y2
	for( i = 0; i < n; ++i) {
		left_dist = right_dist = INT64_MAX;
		// normalno ako nema ni s leve ni s desne idemo dalje
		if ( next_left[i] == NOT_FOUND && next_right[i] == NOT_FOUND ) {
			std::cout << -1 << '\n';
			continue;
		}

		// sad sam shvatio da nam trebaju znakovi za ovo
		// da nisam bilo bi gadno kasnije, kompajler nije ni upozorio
		if ( next_left[i] == NOT_FOUND )
			left_dist = INT64_MAX;
		else
			// jarboli su u nivou
			if( points[i].y == points[next_left[i]].y )
				left_dist = std::abs((int64_t)points[i].x - points[next_left[i]].x);
			// nisu, znaci (x2 - x1) - (y2 - y1)
			else
				left_dist = std::abs((int64_t)points[i].x - points[next_left[i]].x)
									- std::abs((int64_t)points[i].y - points[next_left[i]].y);

		if ( next_right[i] == NOT_FOUND )
			right_dist = INT64_MAX;
		else
			if( points[i].y == points[next_right[i]].y )
				right_dist = std::abs((int64_t)points[i].x - points[next_right[i]].x);
			else
				right_dist = std::abs((int64_t)points[i].x - points[next_right[i]].x)
									- std::abs((int64_t)points[i].y - points[next_right[i]].y);

		std::cout << std::min(left_dist, right_dist) << '\n';
	}
	std::exit(0);
}

int main() noexcept {
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);
  std::cout.tie(nullptr);
  std::cerr.tie(nullptr);

	uint32_t n, i, temp;
	std::cin >> n;

	// ne znam kako se prevodi
	Jarbol jarboli[MAX_N];
	for(i = 0; i < n; ++i)
		std::cin >> jarboli[i].x;

	for(i = 0; i < n; ++i)
		std::cin >> jarboli[i].y;

	// "niz X nije nuzno sortiran"
	std::sort(jarboli, jarboli+n, [](const Jarbol& a, const Jarbol& b) {
		return a.x < b.x;
	});

	solve(jarboli, n);
}